/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef SPICE3_SYSTEM_API_
#define SPICE3_SYSTEM_API_

#include "rlTypes.h"

RL_C_API rlResult rlSystemInitConfig(rlSystemConfig* config);
RL_C_API rlResult rlSystemToStringConfig(const rlSystemConfig* config, char* buffer, uint32_t bufferSize, uint32_t* stringLength);
RL_C_API rlResult rlSystemLoadConfig(rlHandle handle);
RL_C_API rlResult rlSystemStoreConfig(rlHandle handle);
RL_C_API rlResult rlSystemGetConfig(rlHandle handle, rlSystemConfig* config);
RL_C_API rlResult rlSystemSetConfig(rlHandle handle, const rlSystemConfig* config);

RL_C_API rlResult rlSystemGetFirmwareVersion(rlHandle handle, char* buffer, uint32_t bufferSize, uint32_t* stringLength);
RL_C_API rlResult rlSystemGetFirmwareProductVersion(rlHandle handle, char* buffer, uint32_t bufferSize, uint32_t* stringLength);
RL_C_API rlResult rlSystemGetFPGAVersion(rlHandle handle, char* buffer, uint32_t bufferSize, uint32_t* stringLength);
RL_C_API rlResult rlSystemGetOSVersion(rlHandle handle, char* buffer, uint32_t bufferSize, uint32_t* stringLength);
RL_C_API rlResult rlSystemGetCardSerialNumber(rlHandle handle, char* buffer, uint32_t bufferSize, uint32_t* stringLength);

RL_C_API rlResult rlSystemGetConnectionLimit(rlHandle handle, int32_t* out);
RL_C_API rlResult rlSystemGetUniversalTime(rlHandle handle, time_t* out);
RL_C_API rlResult rlSystemGetTime(rlHandle handle, time_t* out);
RL_C_API rlResult rlSystemSetSystemTime(rlHandle handle, time_t time);

RL_C_API rlResult rlSystemGetSupportedTimeZones(rlHandle handle, rlTimeZone* buffer, uint32_t bufferSize, uint32_t* outCount);

RL_C_API rlResult rlSystemResetToDefaults(rlHandle handle);

RL_C_API rlResult rlSystemResetOperatingState(rlHandle handle);
RL_C_API rlResult rlSystemGetOperatingState(rlHandle handle, rlOperatingState* result);
#endif // SPICE3_SYSTEM_API_
